/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.waterwheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.waterwheel.WaterWheelTileEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2258;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_6328;

@ParametersAreNonnullByDefault
@class_6328
public class WaterWheelBlock
extends DirectionalKineticBlock
implements ITE<WaterWheelTileEntity> {
    public WaterWheelBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
        for (class_2350 direction : Iterate.directions) {
            class_2338 neighbourPos = pos.method_10093(direction);
            class_2680 neighbourState = worldIn.method_8320(neighbourPos);
            if (!AllBlocks.WATER_WHEEL.has(neighbourState) || ((class_2350)neighbourState.method_11654((class_2769)FACING)).method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166() && ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == direction.method_10166()) continue;
            return false;
        }
        return true;
    }

    public class_2680 method_9559(class_2680 stateIn, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (worldIn instanceof WrappedWorld) {
            return stateIn;
        }
        this.updateFlowAt(stateIn, worldIn, currentPos, facing);
        this.updateWheelSpeed(worldIn, currentPos);
        return stateIn;
    }

    @Override
    public void method_9615(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 oldState, boolean isMoving) {
        super.method_9615(state, worldIn, pos, oldState, isMoving);
        this.updateAllSides(state, worldIn, pos);
    }

    public void updateAllSides(class_2680 state, class_1937 worldIn, class_2338 pos) {
        for (class_2350 d : Iterate.directions) {
            this.updateFlowAt(state, (class_1936)worldIn, pos, d);
        }
        this.updateWheelSpeed((class_1936)worldIn, pos);
    }

    private void updateFlowAt(class_2680 state, class_1936 world, class_2338 pos, class_2350 side) {
        class_2680 adjacentBlock;
        if (side.method_10166() == ((class_2350)state.method_11654((class_2769)FACING)).method_10166()) {
            return;
        }
        class_3610 fluid = world.method_8316(pos.method_10093(side));
        class_2350 wf = (class_2350)state.method_11654((class_2769)FACING);
        boolean clockwise = wf.method_10171() == class_2350.class_2352.field_11056;
        int clockwiseMultiplier = 2;
        class_243 vec = fluid.method_15758((class_1922)world, pos.method_10093(side));
        if (side.method_10166().method_10179() && (adjacentBlock = world.method_8320(pos.method_10093(side))).method_26204() == class_2246.field_10422) {
            vec = new class_243(0.0, (Boolean)adjacentBlock.method_11654((class_2769)class_2258.field_10680) != false ? -1.0 : 1.0, 0.0);
        }
        vec = vec.method_1021((double)side.method_10171().method_10181());
        class_243 flow = vec = new class_243(Math.signum(vec.field_1352), Math.signum(vec.field_1351), Math.signum(vec.field_1350));
        this.withTileEntityDo((class_1922)world, pos, te -> {
            double flowStrength = 0.0;
            if (wf.method_10166() == class_2350.class_2351.field_11051) {
                if (side.method_10166() == class_2350.class_2351.field_11052) {
                    double d = flowStrength = flow.field_1352 > 0.0 ^ !clockwise ? -flow.field_1352 * (double)clockwiseMultiplier : -flow.field_1352;
                }
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    double d = flowStrength = flow.field_1351 < 0.0 ^ !clockwise ? flow.field_1351 * (double)clockwiseMultiplier : flow.field_1351;
                }
            }
            if (wf.method_10166() == class_2350.class_2351.field_11048) {
                if (side.method_10166() == class_2350.class_2351.field_11052) {
                    double d = flowStrength = flow.field_1350 < 0.0 ^ !clockwise ? flow.field_1350 * (double)clockwiseMultiplier : flow.field_1350;
                }
                if (side.method_10166() == class_2350.class_2351.field_11051) {
                    double d = flowStrength = flow.field_1351 > 0.0 ^ !clockwise ? -flow.field_1351 * (double)clockwiseMultiplier : -flow.field_1351;
                }
            }
            if (wf.method_10166() == class_2350.class_2351.field_11052) {
                if (side.method_10166() == class_2350.class_2351.field_11051) {
                    double d = flowStrength = flow.field_1352 < 0.0 ^ !clockwise ? flow.field_1352 * (double)clockwiseMultiplier : flow.field_1352;
                }
                if (side.method_10166() == class_2350.class_2351.field_11048) {
                    double d = flowStrength = flow.field_1350 > 0.0 ^ !clockwise ? -flow.field_1350 * (double)clockwiseMultiplier : -flow.field_1350;
                }
            }
            if (te.getSpeed() == 0.0f && flowStrength != 0.0 && !world.method_8608()) {
                te.award(FluidHelper.isLava(fluid.method_15772()) ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
            }
            Integer flowModifier = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
            te.setFlow(side, (float)(flowStrength * (double)flowModifier.intValue() / 2.0));
        });
    }

    private void updateWheelSpeed(class_1936 world, class_2338 pos) {
        this.withTileEntityDo((class_1922)world, pos, GeneratingKineticTileEntity::updateGeneratedRotation);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        boolean sneaking;
        class_2350 face = context.method_8038();
        class_2350 horizontalFacing = context.method_8042();
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_2680 placedOn = world.method_8320(pos.method_10093(face.method_10153()));
        if (AllBlocks.WATER_WHEEL.has(placedOn)) {
            return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)((class_2350)placedOn.method_11654((class_2769)FACING)));
        }
        class_2350 facing = face;
        boolean bl = sneaking = player != null && player.method_5715();
        if (player != null) {
            class_243 lookVec = player.method_5720();
            double tolerance = 0.985;
            facing = !this.method_9558((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11036), (class_4538)world, pos) ? horizontalFacing : (class_243.method_24954((class_2382)class_2350.field_11033.method_10163()).method_1026(lookVec.method_1029()) > tolerance ? class_2350.field_11033 : (class_243.method_24954((class_2382)class_2350.field_11036.method_10163()).method_1026(lookVec.method_1029()) > tolerance ? class_2350.field_11036 : horizontalFacing));
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)(sneaking ? facing.method_10153() : facing));
    }

    @Override
    public boolean hasShaftTowards(class_4538 world, class_2338 pos, class_2680 state, class_2350 face) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166() == face.method_10166();
    }

    @Override
    public class_2350.class_2351 getRotationAxis(class_2680 state) {
        return ((class_2350)state.method_11654((class_2769)FACING)).method_10166();
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public boolean hideStressImpact() {
        return true;
    }

    @Override
    public Class<WaterWheelTileEntity> getTileEntityClass() {
        return WaterWheelTileEntity.class;
    }

    @Override
    public class_2591<? extends WaterWheelTileEntity> getTileEntityType() {
        return (class_2591)AllTileEntities.WATER_WHEEL.get();
    }

    public static Couple<Integer> getSpeedRange() {
        Integer base = (Integer)AllConfigs.SERVER.kinetics.waterWheelBaseSpeed.get();
        Integer flow = (Integer)AllConfigs.SERVER.kinetics.waterWheelFlowSpeed.get();
        return Couple.create(base, base + 4 * flow);
    }
}

